#!/bin/bash
if [ $# -lt 3 ];then
{
	echo -e "Usage: make_header -option\noption: -i imagepath\n\t-a(ap)\n\t-p plcpath\n\t-m(md5)\n\t-r(reset)"
	exit 1
}
fi

apfile=NULL
apubootfile=NULL
nvmfile=NULL
pibfile=NULL
gglfile=NULL
md5=NULL
reset=NULL

while getopts "i:ap:n:g:mr" arg
do
	case $arg in
		i)
			#echo "imagepath:$OPTARG"
			Imagepath=$OPTARG
			;;
		a)
			#echo "ap"
			apfile=`find $Imagepath -name "*-up-*.bin" | xargs ls -t | head -n 1`
			if [ ! $apfile ]; then
				{
					echo "can't find ap upfile"
					exit 1
				}
			fi
			;;
		p)
			#echo "plc"
			plcImagepath=$OPTARG
			
			nvmfile=`find $plcImagepath -name "*.nvm" | xargs -r ls -t | head -n 1`
			if [ ! $nvmfile ]; then  
				nvmfile=NULL  
			fi
			pibfile=`find $plcImagepath -name "*.pib" | xargs -r ls -t | head -n 1`
			if [ ! $pibfile ]; then  
				pibfile=NULL  
			fi
			gglfile=`find $plcImagepath -name "*.ggl" | xargs -r ls -t | head -n 1`
			if [ ! $gglfile ]; then  
				gglfile=NULL 
			fi
            ;;
		m)
			#echo "md5"
			md5=TRUE
			;;
		r)
			#echo "reset"
			reset=TRUE
			;;
		?)
			echo "unknown argument"
			exit 1
			;;
	esac
done

cd $Imagepath

./make_header $apfile $nvmfile $pibfile $gglfile $md5 $reset
if [ $? -eq 0 ]; then
{
	#cp *.bin $Imagepath
	echo "make_header Success"
	#rm $apfile
}
else
{
	echo "make_header error"
	exit 1
}
fi
